VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "Customers"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Attribute VB_Ext_KEY = "RVB_UniqueId" ,"32FA94B6003D"
'
Option Base 0
Option Explicit
Implements ObjectControl

Private oDCustomers As DpkgCustomers.DCustomers

Private oObjectContext As ObjectContext

Private Function ObjectControl_CanBePooled() As Boolean
    ObjectControl_CanBePooled = True
End Function

Private Sub ObjectControl_Deactivate()
    Set oObjectContext = Nothing
    Set oDCustomers = Nothing
End Sub

Private Sub ObjectControl_Activate()
    On Error GoTo OCActivateErr
   
    Set oObjectContext = GetObjectContext()
    Set oDCustomers = oObjectContext.CreateInstance("DpkgCustomers.DCustomers")
        
    Exit Sub

OCActivateErr:
    Call RaiseError("OCActivate")

End Sub

Public Function UpdateCustomer(ByVal vCustData As Variant) As Variant
On Error GoTo UpdateCustomerErr
    
    Dim vResponse As Variant
 
    Set vResponse = oDCustomers.UpdateCustomer(vCustData)
     
    oObjectContext.SetComplete
    Set UpdateCustomer = vResponse

    Exit Function
    
UpdateCustomerErr:
    oObjectContext.SetAbort
    Set UpdateCustomer = RaiseError("UpdateCustomer")
    
    End Function

Public Function RegisterCustomer(ByVal vCustData As Variant) As Variant
    On Error GoTo RegisterCustomerErr
    
    Dim vResponse As Variant

    Set vResponse = AuthenticateCustomer(vCustData)
    If Not vResponse("error") And _
       Not vResponse("exists") Then
            Set vResponse = oDCustomers.InsertCustomer(vCustData)
            vResponse.Add True, Key:="passcodevalid"
    End If
                
    oObjectContext.SetComplete
    Set RegisterCustomer = vResponse

    Exit Function
    
RegisterCustomerErr:
    oObjectContext.SetAbort
    Set RegisterCustomer = RaiseError("RegisterCustomer")

End Function


Public Function AuthenticateCustomer(ByVal vCustData As Variant) As Variant
    On Error GoTo AuthenticateCustomerErr
    
    Dim vPasscode2 As Variant
    Dim vResponse As Variant
    Dim vCustData2 As Variant
    Dim vResponse2 As Variant
    
    vPasscode2 = vCustData("passcode")
    
    Set oDCustomers = oObjectContext.CreateInstance("DpkgCustomers.DCustomers")

    Set vResponse = oDCustomers.SelectCustomer(vCustData)
    If Not vResponse("error") Then
        If vResponse("exists") Then
            Set vCustData2 = vResponse("CustData")
            Set vResponse2 = New Collection
            vResponse2.Add False, Key:="error"
            vResponse2.Add True, Key:="exists"
            vResponse2.Add vCustData2, Key:="custdata"
            If (Trim(vCustData2("passcode")) Like Trim(vPasscode2)) Then
                vResponse2.Add True, Key:="passcodevalid"
            Else
                vResponse2.Add False, Key:="passcodevalid"
            End If
            Set vResponse = vResponse2
       End If
    End If
      
    oObjectContext.SetComplete
    Set AuthenticateCustomer = vResponse

    Exit Function
    
AuthenticateCustomerErr:
    oObjectContext.SetAbort
    Set AuthenticateCustomer = RaiseError("AuthenticateCustomer")

End Function

'##ModelId=32FAA6A90370
Private Sub Class_Initialize()
 
End Sub

'##ModelId=32FA94B6014C
Private Sub Class_Terminate()

End Sub


